using System.Collections.Generic;
using RimWorld;
using UnityEngine;
using Verse;
using Verse.AI;

namespace Therapy
{
    public class JobDriver_Therapize : JobDriver
    {
        public override bool TryMakePreToilReservations()
        {
            return pawn.Reserve(job.GetTarget(TargetIndex.A), job) && pawn.Reserve(job.GetTarget(TargetIndex.B), job);
        }

        protected override IEnumerable<Toil> MakeNewToils()
        {
            this.EndOnDespawnedOrNull(TargetIndex.A); // Chair
            this.EndOnDespawnedOrNull(TargetIndex.B); // Patient
            this.FailOnMentalState(TargetIndex.B);
            this.FailOnDowned(TargetIndex.B);
            
            //yield return Toils_Reserve.Reserve(TargetIndex.A);
            //yield return Toils_Reserve.Reserve(TargetIndex.B);
            yield return Toils_Goto.GotoThing(TargetIndex.A, PathEndMode.OnCell);
            Toil councel = new Toil();
            councel.tickAction = delegate {
                rotateToFace = TargetIndex.C; // Nothing, so rotator doesn't get overwritten
                pawn.rotationTracker.FaceCell(TargetLocA + TargetThingA.Rotation.FacingCell);
                //float statValue = TargetThingA.GetStatValue(StatDefOf.EntertainmentStrengthFactor);
                //float extraJoyGainFactor = statValue;
                //JoyUtility.JoyTickCheckEnd(pawn, JoyTickFullJoyAction.EndJob, extraJoyGainFactor);

                pawn.skills.Learn(SkillDefOf.Social, 0.11f);
                pawn.GainComfortFromCellIfPossible();

                CouncelPatient((Pawn) TargetThingB);
            };
            councel.defaultCompleteMode = ToilCompleteMode.Delay;
            councel.defaultDuration = 8000;
            councel.socialMode = RandomSocialMode.Off;
            councel.FailOnDowned(TargetIndex.B);
            councel.FailOnMentalState(TargetIndex.B);
            councel.FailOn(PatientNotOnCouch);
            councel.AddFinishAction(()=> {
                if (TargetB.HasThing) Dismiss((Pawn)TargetThingB);
            });
            yield return councel;
        }

        private static void Dismiss(Pawn patient)
        {
            patient.jobs.EndCurrentJob(JobCondition.Succeeded);
        }

        private bool PatientNotOnCouch(Toil toil)
        {
            if (TargetThingB == null) return true;
            if (!TargetThingB.Spawned) return true;
            var couch = TargetThingB.Position.GetEdifice(TargetThingB.Map);
            if (couch == null) return true;
            return false;
        }

        private void CouncelPatient(Pawn patient)
        {
            if (patient.IsHashIntervalTick(150))
            {
                //Log.Message(pawn.NameStringShort+ " is therapizing "+patient.NameStringShort);
                Room room = pawn.GetRoom();
                Building_Couch couch = patient.CurrentCouch();
                if (room != null && couch != null)
                {
                    float effect = Mathf.Max(0, pawn.GetStatValue(StatDefOf.SocialImpact));
                    effect *= Mathf.Max(0, couch.GetStatValue(StatDefOf.Comfort));
                    effect *= Mathf.Max(0, room.GetStat(RoomStatDefOf.Beauty));

                    int amount = (int) (effect*150*3);

                    var driver = patient.jobs.curDriver as JobDriver_ReceiveTherapy;
                    if (driver != null)
                    {
                        driver.HealMemories(amount);
                    }
                    else
                    {
                        Log.Message("Patient "+patient.NameStringShort+" has wrong JobDriver: "+patient.jobs.curDriver);
                    }
                }
            }
            if (patient.IsHashIntervalTick(350))
            {
                ShowInteractionBubble(patient);
            }
        }

        private void ShowInteractionBubble(Pawn patient)
        {
            switch (Rand.RangeInclusive(0, 2))
            {
                case 0:
                    return;
                case 1:
                    TryCreateBubble(patient, pawn, Rand.Element(ModBaseTherapy.symbolPatient1, ModBaseTherapy.symbolPatient2));
                    return;
                case 2:
                    TryCreateBubble(pawn, patient, Rand.Element(ModBaseTherapy.symbolTherapist1, ModBaseTherapy.symbolTherapist2));
                    return;
            }
        }

        private static void TryCreateBubble(Pawn pawn1, Pawn pawn2, Texture2D symbol)
        {
            if (pawn1.interactions.InteractedTooRecentlyToInteract()) return;
            MoteMaker.MakeInteractionBubble(pawn1, pawn2, ThingDefOf.Mote_Speech, symbol);
        }
    }
}